<?xml version="1.0"?> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" omit-xml-declaration="yes"
	doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
	doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd"
	indent="yes"/>
 <!-- Display Parameters -->
<xsl:param name="xsl_version">1</xsl:param>
<xsl:param name="min_user_level">0</xsl:param>
<xsl:param name="min_user_table">5</xsl:param>
 <!-- Root template -->
 <xsl:template match="/PABX">
   <HTML>
   <HEAD>
   <TITLE>
    <xsl:value-of select="General/Name"/>
   </TITLE>
   <link rel="stylesheet" type="text/css" href="PABXCONF.css" />
   </HEAD>
   <BODY>

<xsl:if test="string-length(/PABX/@XSL) &gt; 0">
<xsl:if test="/PABX/@XSL &gt; $xsl_version">
<h1 class="WarningHeading">Style sheet warning</h1>
<p class="WarningMessage">Style sheet version is too low so some information may be mising. Version <xsl:value-of select="/PABX/@XSL"/> of the style sheet is needed</p>
</xsl:if>
</xsl:if>

        <xsl:apply-templates select="General"/><br></br>
  <HR></HR>
        <xsl:apply-templates select="classes"/><br></br>
  <HR></HR>
        <xsl:apply-templates select="users"/>
  <HR></HR>
        <xsl:apply-templates select="templates"/>
  <HR></HR>
        <xsl:apply-templates select="extensions"/>
  <HR></HR>
        <xsl:apply-templates select="externals"/>
  <HR></HR>
        <xsl:apply-templates select="groups"/>
  <HR></HR>
        <xsl:apply-templates select="timing"/><br></br>
  <HR></HR>
   </BODY>
  </HTML>
 </xsl:template>

 <xsl:template match="General">
<DIV CLASS="DivTableStyle">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<TD CLASS="MainHeadingBar" COLSPAN="2">General Information</TD>
</TR>
<TR>
<TD CLASS="TableInfoTitle" WIDTH="20%">Configuration Name</TD>
<TD CLASS="TableInfoL" WIDTH="80%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="Name"/></TD>
</TR>
<TR>
<TD CLASS="TableInfoTitle" WIDTH="20%">Last Updated</TD>
<TD CLASS="TableInfoL" WIDTH="80%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="updated"/></TD>
</TR>
<TR>
<TD CLASS="TableInfoTitle" WIDTH="20%">Configuration Version</TD>
<TD CLASS="TableInfoL" WIDTH="80%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="Version"/></TD>
</TR>
        <xsl:apply-templates select="notes"/>
</TABLE>
</DIV>
 </xsl:template>

 <xsl:template match="General/notes">
    <xsl:apply-templates/>
 </xsl:template>

<xsl:template match="General/notes/note">
<TR>
<TD CLASS="TableInfoTitle">Note<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
<xsl:if test="string-length(@time) &gt; 0">
<font class="FontData">(<xsl:value-of select="@time"/>)</font>
</xsl:if>
</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:apply-templates/></TD>
</TR>
 </xsl:template>

 <xsl:template match="classes">
<DIV CLASS="DivTableStyle">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<TD CLASS="MainHeadingBar" COLSPAN="4">Classes</TD>
</TR>
<TR>
<TD CLASS="TableInfoTitle" WIDTH="10%">Name</TD>
<TD CLASS="TableInfoTitle" WIDTH="10%">Type</TD>
<TD CLASS="TableInfoTitle" WIDTH="10%">Last Updated</TD>
<TD CLASS="TableInfoTitle" WIDTH="30%">Notes</TD>
</TR>
     <xsl:apply-templates/>
</TABLE>
</DIV>
 </xsl:template>
 <xsl:template match="class">
<TR>
<TD CLASS="TableInfoL" WIDTH="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="name"/></TD>
<TD CLASS="TableInfoL" WIDTH="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="type"/></TD>
<TD CLASS="TableInfoL" WIDTH="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="updated"/></TD>
<TD CLASS="TableInfoL" WIDTH="40%"><xsl:apply-templates select="notes"/></TD>
</TR>
 </xsl:template>

 <xsl:template match="class/notes">
    <xsl:apply-templates/>
 </xsl:template>

<xsl:template match="class/notes/note">
<xsl:if test="position() &gt; 1"><br/></xsl:if>
<xsl:if test="string-length(@time) &gt; 0">
<font class="FontData">(<xsl:value-of select="@time"/>)</font>
<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
</xsl:if>
<xsl:apply-templates/>
</xsl:template>

 <xsl:template match="users">
   <xsl:choose>
     <xsl:when test="@type = 'special'">
      <xsl:if test="$min_user_table &gt;= 2">
       <DIV CLASS="DivTableStyle">
        <TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
         <TR>
          <TD CLASS="MainHeadingBar">System Users</TD>
         </TR>
         <xsl:apply-templates/>
        </TABLE><br></br>
       </DIV>
      </xsl:if>
     </xsl:when>
     <xsl:when test="@type = 'system'">
      <xsl:if test="$min_user_table &gt;= 1">
       <DIV CLASS="DivTableStyle">
        <TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
         <TR>
          <TD CLASS="MainHeadingBar">Special Users</TD>
         </TR>
         <xsl:apply-templates/>
        </TABLE><br></br>
       </DIV>
      </xsl:if>
     </xsl:when>
     <xsl:when test="@type = 'user'">
      <xsl:if test="$min_user_table &gt;= 0">
       <DIV CLASS="DivTableStyle">
        <TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
         <TR>
          <TD CLASS="MainHeadingBar">Users</TD>
         </TR>
         <xsl:apply-templates/>
        </TABLE><br></br>
       </DIV>
      </xsl:if>
     </xsl:when>
     <xsl:otherwise>
       <DIV CLASS="DivTableStyle">
        <TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
         <TR>
          <TD CLASS="MainHeadingBar">Users (Unknown Type)</TD>
         </TR>
         <xsl:apply-templates/>
        </TABLE><br></br>
       </DIV>
     </xsl:otherwise>
   </xsl:choose>
 </xsl:template>

 <xsl:template match="user">
 <xsl:if test="level &gt; $min_user_level">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<TD CLASS="TableInfoName" colspan="8"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="name"/></TD>
</TR>
<TR>
<TD CLASS="TableInfoTitle" WIDTH="10%">Type</TD>
<TD CLASS="TableInfoTitle" WIDTH="5%">System ID</TD>
<TD CLASS="TableInfoTitle" WIDTH="5%">Public ID</TD>
<TD CLASS="TableInfoTitle" WIDTH="5%">Passcode</TD>
<TD CLASS="TableInfoTitle" WIDTH="5%">Ring Type</TD>
<TD CLASS="TableInfoTitle" WIDTH="5%">Level</TD>
<TD CLASS="TableInfoTitle" WIDTH="5%">Priority</TD>
<TD CLASS="TableInfoTitle" WIDTH="5%">Icon</TD>
</TR>
<TR>
<TD CLASS="TableInfoL" WIDTH="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="@type"/></TD>
<TD CLASS="TableInfoL" WIDTH="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="@ID"/></TD>
<xsl:choose>
 <xsl:when test="substring(publicid,1,1)='A'">
  <TD CLASS="TableInfoL" WIDTH="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>hidden</TD>
 </xsl:when>
 <xsl:otherwise>
  <TD CLASS="TableInfoL" WIDTH="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="publicid"/></TD>
 </xsl:otherwise>
</xsl:choose>
<xsl:choose>
 <xsl:when test="substring(publicid,1,1)='A'">
  <TD CLASS="TableInfoL" WIDTH="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>hidden</TD>
 </xsl:when>
 <xsl:otherwise>
  <TD CLASS="TableInfoL" WIDTH="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="passcode"/></TD>
 </xsl:otherwise>
</xsl:choose>
<TD CLASS="TableInfoL" WIDTH="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="ringtype"/></TD>
<TD CLASS="TableInfoL" WIDTH="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="level"/></TD>
<TD CLASS="TableInfoL" WIDTH="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="priority"/></TD>
<TD CLASS="TableInfoL" WIDTH="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="icon"/></TD>
</TR>
<TR>
<TD CLASS="TableInfoTitle">Class access</TD>
<TD CLASS="TableInfoL" colspan="7"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="class/@Default"/></TD>
</TR>
<xsl:if test="string-length(class/allowed) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle">Class allowed</TD>
<TD CLASS="TableInfoL" colspan="7"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="class/allowed"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(class/banned) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle">Class banned</TD>
<TD CLASS="TableInfoL" colspan="7"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="class/banned"/></TD>
</TR>
</xsl:if>
<TR>
<TD CLASS="TableInfoTitle">Rights access</TD>
<TD CLASS="TableInfoL" colspan="7"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rights/@Default"/>
<xsl:if test="string(rights/@Override) != ''">(Overriding extensions limits)</xsl:if>
</TD>
</TR>
<xsl:if test="string-length(rights/allowed) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle">Rights allowed</TD>
<TD CLASS="TableInfoL" colspan="7"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rights/allowed"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(rights/banned) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle">Rights banned</TD>
<TD CLASS="TableInfoL" colspan="7"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rights/banned"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(updated) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle">Record Last Updated</TD>
<TD CLASS="TableInfoL" colspan="7"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="updated"/></TD>
</TR>
</xsl:if>
        <xsl:apply-templates select="notes"/>
</TABLE><br></br>
 </xsl:if>
 </xsl:template>

 <xsl:template match="user/notes">
    <xsl:apply-templates/>
 </xsl:template>

 <xsl:template match="user/notes/note">
 <TR>
<TD CLASS="TableInfoTitle">Note<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
<xsl:if test="string-length(@time) &gt; 0">
<font class="FontData">(<xsl:value-of select="@time"/>)</font>
</xsl:if>
</TD>
<TD CLASS="TableInfoL" colspan="6"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:apply-templates/></TD>
</TR>
 </xsl:template>

<xsl:template match="extensions">
<DIV CLASS="DivTableStyle">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<TD CLASS="MainHeadingBar">Extensions</TD>
</TR>
     <xsl:apply-templates/>
</TABLE><br></br>
</DIV>
</xsl:template>

<xsl:template match="externals">
<DIV CLASS="DivTableStyle">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<TD CLASS="MainHeadingBar">External Lines</TD>
</TR>
     <xsl:apply-templates/>
</TABLE><br></br>
</DIV>
</xsl:template>

<xsl:template match="templates">
<DIV CLASS="DivTableStyle">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<TD CLASS="MainHeadingBar">Templates</TD>
</TR>
     <xsl:apply-templates/>
</TABLE><br></br>
</DIV>
</xsl:template>

<xsl:template match="ext|template">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<xsl:if test="string-length(name) = 0">
<TD CLASS="TableInfoName" colspan="8"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>No Name</TD>
</xsl:if>
<xsl:if test="string-length(name) &gt; 0">
<TD CLASS="TableInfoName" colspan="8"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="name"/>
</TD>
</xsl:if>
</TR>

<xsl:if test="string-length(@template) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Template</TD>
<TD CLASS="TableInfoL" width="80%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="@template"/></TD>
</TR>
</xsl:if>

<xsl:if test="string-length(template) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Template</TD>
<TD CLASS="TableInfoL" width="80%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="template"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(type) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Type</TD>
<TD CLASS="TableInfoL" width="80%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="type"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(position) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Position</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="position"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(location) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Ship's Location</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="location"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(number) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Ext. Number</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="number/std"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(number/alt) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle" width="15%">Alternative Number(s)</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="number/alt"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(rights/@User) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Default User</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rights/@User"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(class/@Member) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Class Member</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="class/@Member"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(action) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Off-Hook Action</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
</TR>
<xsl:if test="string-length(action/mode) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Mode</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="action/mode"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(action/delay) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Action Delay</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="action/delay"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(action/delay) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Call Extension</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="action/extension"/></TD>
</TR>
</xsl:if>
</xsl:if>
<xsl:if test="string-length(Flags) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Flags</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
</TR>
<xsl:if test="string-length(Flags/GlobalDir) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">In Global Directory</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="Flags/GlobalDir"/></TD>
</TR>
</xsl:if>
</xsl:if>
<xsl:if test="string-length(CLI) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Caller Display Indication</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
</TR>
<xsl:if test="string-length(CLI/Allow) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Allow</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="CLI/Allow"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(CLI/Style) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Style</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="CLI/Style"/></TD>
</TR>
</xsl:if>
</xsl:if>
<xsl:if test="string-length(Logging) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Call Logging</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
</TR>
<xsl:if test="string-length(Logging/From) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">From Extension</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="Logging/From"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(Logging/To) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">To Extension</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="Logging/To"/></TD>
</TR>
</xsl:if>
</xsl:if>
<xsl:if test="string-length(txgain) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Transmit Gain</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="txgain"/> dB</TD>
</TR>
</xsl:if>
<xsl:if test="string-length(rxgain) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Receive Gain</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rxgain"/> dB</TD>
</TR>
</xsl:if>

<xsl:if test="string-length(Groups) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Groups</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
</TR>
<xsl:if test="string-length(Groups/Ring) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Ring</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="Groups/Ring"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(Groups/Hunt) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Hunt</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="Groups/Hunt"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(Groups/Pickup) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Pickup</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="Groups/Pickup"/></TD>
</TR>
</xsl:if>
</xsl:if>
<xsl:if test="string-length(class) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Class access</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="class/@Default"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(class/allowed) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle" width="15%">Access allowed</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="class/allowed"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(class/banned) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle" width="25%">Access banned</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="class/banned"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(class/never) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle" width="15%">Access always allowed</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="class/always"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(class/never) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle" width="15%">Access always banned</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="class/never"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(rights) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Rights access</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rights/@Default"/>
</TD>
</TR>
</xsl:if>
<xsl:if test="string-length(rights/allowed) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Rights allowed</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rights/allowed"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(rights/banned) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Rights banned</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rights/banned"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(rights/always) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Rights always allowed</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rights/always"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(rights/never) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle">Rights always banned</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="rights/never"/></TD>
</TR>
</xsl:if>
<xsl:if test="string-length(updated) &gt; 0">
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Record Last Updated</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="updated"/></TD>
</TR>
</xsl:if>
        <xsl:apply-templates select="notes"/>
</TABLE><br></br>
 </xsl:template>

<xsl:template match="groups">
<DIV CLASS="DivTableStyle">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<TD CLASS="MainHeadingBar">Groups</TD>
</TR>
     <xsl:apply-templates/>
</TABLE><br></br>
</DIV>
 </xsl:template>
 <xsl:template match="group">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<xsl:if test="string-length(name) = 0">
<TD CLASS="TableInfoName" colspan="8"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>No Name</TD>
</xsl:if>
<xsl:if test="string-length(name) &gt; 0">
<TD CLASS="TableInfoName" colspan="8"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="name"/></TD>
</xsl:if>
</TR>
<xsl:if test="string-length(type) &gt; 0">
 <TR>
<TD CLASS="TableInfoTitle">Type</TD>
<TD CLASS="TableInfoL" colspan="6"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="type"/></TD>
</TR>
</xsl:if>
<TR>
<TD CLASS="TableInfoTitle" colspan="6">Group Members</TD>
</TR>
<TR>
<TD CLASS="TableInfoL" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoTitle" width="10%">Mode</TD>
<TD CLASS="TableInfoTitle" width="10%">Delay</TD>
<TD CLASS="TableInfoTitle" width="75%">Who</TD>
</TR>
        <xsl:apply-templates select="lead"/>
        <xsl:apply-templates select="member"/>
<TR>
<TD CLASS="TableInfoTitle" colspan="2">Record Last Updated</TD>
<TD CLASS="TableInfoL"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="updated"/></TD>
</TR>
        <xsl:apply-templates select="notes"/>
</TABLE><br></br>
 </xsl:template>

<xsl:template match="group/member">
<TR>
<TD CLASS="TableInfoL" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoL" width="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="@mode"/></TD>
<TD CLASS="TableInfoL" width="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="@delay"/></TD>
<TD CLASS="TableInfoL" width="75%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:apply-templates/></TD>
</TR>
</xsl:template>
<xsl:template match="group/lead">
<TR>
<TD CLASS="TableInfoL" width="5%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text></TD>
<TD CLASS="TableInfoL" width="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="@mode"/></TD>
<TD CLASS="TableInfoL" width="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>n/a</TD>
<TD CLASS="TableInfoL" width="75%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:apply-templates/></TD>
</TR>
</xsl:template>


 <xsl:template match="group/notes">
    <xsl:apply-templates/>
 </xsl:template>

 <xsl:template match="group/notes/note">
 <TR>
<TD CLASS="TableInfoTitle">Note<xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>
<xsl:if test="string-length(@time) &gt; 0">
<font class="FontData">(<xsl:value-of select="@time"/>)</font>
</xsl:if>
</TD>
<TD CLASS="TableInfoL" colspan="6"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:apply-templates/></TD>
</TR>
 </xsl:template>


<xsl:template match="timing">
<DIV CLASS="DivTableStyle">
<TABLE CELLSPACING="0" CLASS="TableLayout" WIDTH="100%">
<TR>
<TD CLASS="MainHeadingBar" COLSPAN="4">Timings</TD>
</TR>
<TR>
<TD CLASS="TableInfoTitle" WIDTH="10%">Name</TD>
<TD CLASS="TableInfoTitle" WIDTH="90%">Length</TD>
</TR>
     <xsl:apply-templates/>
</TABLE>
</DIV>
 </xsl:template>
 <xsl:template match="time">
<TR>
<TD CLASS="TableInfoL" WIDTH="10%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:value-of select="@name"/></TD>
<TD CLASS="TableInfoL" WIDTH="90%"><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text><xsl:apply-templates/><xsl:text disable-output-escaping="yes">&amp;nbsp;</xsl:text>secs</TD>
</TR>
 </xsl:template>


</xsl:stylesheet>
